--sysParam.lua

sysParam = {}

function sysParam.init()

    local fst = get_uint16(VT_RW, 0x7FFF)
    if fst ~= 0x55AA
    then
        set_uint16(VT_LW, regAddr.sysCfg0, 1)
        set_uint16(VT_LW, regAddr.sysLang, 0)
        set_uint16(VT_LW, regAddr.sysBLLevel, 100)
        set_uint16(VT_LW, regAddr.sysSndVol, 80)

        set_uint16(VT_LW, regAddr.sysParamSlct, (1 << 3)|(1 << 2)|(1 << 1)|(1 << 0))
        set_uint16(VT_LW, regAddr.sysParamCtrl, 0x5501)
        update_system()
        set_uint16(VT_RW, 0x7FFF, 0x55AA)

    end


    set_uint16(VT_LW, regAddr.sysParamSlct, (1 << 3)|(1 << 2)|(1 << 1)|(1 << 0))
    set_uint16(VT_LW, regAddr.sysParamCtrl, 0x5502)
    update_system()
end


function sysParam.set(slave,vtype,addr)
    if vtype == VT_LW
    then
        print('sysParam.set('..slave..','..vtype..','..(string.format('%04X', addr))..')...')
        if addr == regAddr.sysCfg0
        then
            set_uint16(VT_LW, regAddr.sysParamSlct, (1 << 0))
            set_uint16(VT_LW, regAddr.sysParamCtrl, 0x5501)
            update_system()
        elseif addr == regAddr.sysLang
        then
            set_uint16(VT_LW, regAddr.sysParamSlct, (1 << 1))
            set_uint16(VT_LW, regAddr.sysParamCtrl, 0x5501)
            update_system()
        elseif addr == regAddr.sysSndVol
        then
            set_uint16(VT_LW, regAddr.sysParamSlct, (1 << 2))
            set_uint16(VT_LW, regAddr.sysParamCtrl, 0x5501)
            update_system()
        elseif addr == regAddr.sysBLLevel
        then
            set_uint16(VT_LW, regAddr.sysParamSlct, (1 << 3))
            set_uint16(VT_LW, regAddr.sysParamCtrl, 0x5501)
            update_system()
        end
    end
end
